#! /bin/sh
#---------------------------------------------------------
# Run Performance Test
#
# Arguments:
# $1 : Queue manager name
# $2 : Test list name
# $3 : Output file name
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#---------------------------------------------------------
# return code
RET_OK=0
RET_NG=1

# source environments for performance test
. ./runpfmts.ini

# import library
. ./lib/libpfmts.sh

#------------------------------------------------------------------
# Functions for Performance Tests
#
# input:
# $TARGET_QMGR:  Queue Manager Name
# $TEST_LIST: Test List Name
# ${TEST_LIST}.csv: Test List File Name
#
# output:
# ${TEST_LIST}.out: Output File Name
#
# Test List CSV format:
# Colomn: Description
# 1: Test ID unique for each row
# 2: Number of shot
# 3: 0: Calculate average of all test shots
#    1: Calculate the average of the remaining test shots, excluding
#      the smallest and largest times (valid when the number of shots is
#      3 or more)
# 4: Workload Name
#    RR-1: MQI Local Bindings
#    RR-2: MQI Client Bindings
#    RR-5: MQI Distributed Queuing
#    PL-1: MQ Cluster
# 5: Persistent Mode
#    0: Non-Persistent
#    1: Persistent
# 6: The number of connections
# 7: The number of messages,
# 8: Message size
# 9: Input file Name
#------------------------------------------------------------------
function fnInvokePerformanceFunction
{
  while read Line
  do
    if [[ -z $Line ]] || [[ $Line = \#* ]]
    then
      #echo "continue: $Line"
      continue
    fi

    printf "\n\n%s\n" $Line

    TestID=`echo $Line | awk -F, '{print $1}'`
    Shots=`echo $Line | awk -F, '{print $2}'`
    Mode=`echo $Line | awk -F, '{print $3}'`
    Workload=`echo $Line | awk -F, '{print $4}'`
    Persistent=`echo $Line | awk -F, '{print $5}'`
    Connections=`echo $Line | awk -F, '{print $6}'`
    Messages=`echo $Line | awk -F, '{print $7}'`
    Bytes=`echo $Line | awk -F, '{print $8}'`
    Msgdata=`echo $Line | awk -F, '{print $9}'`

    MQ_CONSTANT=MQPER_NOT_PERSISTENT
    if ((Persistent == 1))
    then
        MQ_CONSTANT=MQPER_PERSISTENT
    fi

    case $Workload in
      RR-1)
        EXEC_SHELL=$RR1_SHELL
        ;;
      RR-1t)
        EXEC_SHELL=$RR1_SHELL_THREAD
        ;;
      RR-2)
        EXEC_SHELL=$RR2_SHELL
        ;;
      RR-2t)
        EXEC_SHELL=$RR2_SHELL_THREAD
        ;;
      RR-5)
        EXEC_SHELL=$RR5_SHELL
        ;;
      PL-1)
        EXEC_SHELL=$PL1_SHELL
        ;;
      *)
       printf "Unknown Workload(%s).\n" $Workload
       return $RET_NG
    esac

    Counter=0

    TESTLOGDIR=logs/${TestID}_`date "+%Y%m%d_%H%M%S"`
    # Create a directory in advance so that the first console message can be written
    mkdir -p $TESTLOGDIR

    while (( Counter < Shots ))
    do
       printf "\n\nTestID: %s Shot: %d\n" ${TestID} $((Counter + 1))

#      time ./$EXEC_SHELL $TARGET_QMGR $Connections $Messages $Bytes $TESTLOGDIR $Workload $MQ_CONSTANT $Msgdata | tee -a $TESTLOGDIR/console.log
      time ./$EXEC_SHELL $TARGET_QMGR $Connections $Messages $Bytes $TESTLOGDIR $Workload $MQ_CONSTANT $Msgdata
      sleep 1
      ((Counter += 1))
    done

#    if [[ -z $OutputFile ]]
#    then
#      fnGetAverageRoundTripsPerSec $TESTLOGDIR/console.log $Mode
#    else
      printf "${TestID}: " >> $OutputFile
      fnGetAverageRoundTripsPerSec $TESTLOGDIR/console.log $Mode | tee -a $OutputFile
#    fi

  done < "$TestListFile"

  return $RET_OK
}

#-------
# Main
#-------
USAGE="usage: $0 <Qmgr> <Test List Name> <Output File Name>"

if (($# < 2))
then
  echo $USAGE
  exit $RET_NG
fi

TARGET_QMGR=${1}
TestListFile=${2}
OutputFile=${3}

# Invoke Performance Function
fnInvokePerformanceFunction
exit $?

