# Windows PwowerShell
#---------------------------------------------------------
# Delete Messages
#
# Arguments:
# $1 : Queue manager name
# Read <QMGR>.mqsc from current directory
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#
#---------------------------------------------------------
Param(
    [String]$m = ""
)

# return code
[int]$RET_OK=0
[int]$RET_NG=1

#---------------------------------------------
# Functions for Command Execution
#---------------------------------------------
function fnExecCmd
{
    $EXECCMD=$args[0]
    #Write-Host ""
    Write-Host "Command: $EXECCMD"
    #Write-Host ""

#    Invoke-Expression "$EXECCMD" | Write-Host
    Invoke-Expression "$EXECCMD"

#    return $RET_OK
}

#------------------------------------------------------------------
# Functions for deleting all messages
#
# input:
# $TARGET_QMGR:  Queue Manager Name
# ${TARGET_QMGR}.mqsc.src:  MQSC source file
#------------------------------------------------------------------
function fnDltMessages
{
    $sourcefile = "${TARGET_QMGR}.mqsc"

    if (!(Test-Path ./$sourceFile))
    {
        Write-Host "Cannot find source file ./$sourcefile"
        return $RET_NG
    }

    $f = (Get-Content ./$sourcefile | select-string "^\s*$" -notmatch | select-string "^\s*#.*$" -notmatch `
        | select-string "^[^`*]*def.*ql" ) -as [string[]]
    $i = 1
    foreach ($line in $f)
    {
        $qnames = $line.Split("()")
        $cmdstring = "mqpgf -qm ${TARGET_QMGR} -q " + $qnames[1] + " -r"
        fnExecCmd $cmdstring
        $i++
    }

#    return $RET_OK
}

#----------------
# Program start
#----------------
if ($m -eq "")
{
    $script_name = $myInvocation.MyCommand.name
    Write-output "${script_name} -m <Qmgr>"
    exit(1)
}

$TARGET_QMGR = $m

# Delete Messages
#$retcd = fnDltMessages
#exit $retcd
fnDltMessages

