# Windows PwowerShell
#---------------------------------------------------------
# Check Channel Status
#
# Arguments:
# $1 : Queue manager name
# Read <QMGR>.mqsc from current directory
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#
#---------------------------------------------------------
Param(
    [String]$m = ""
)

# return code
[int]$RET_OK=0
[int]$RET_NG=1

# import library
. ./lib/libpfmts.ps1

# source environments for performance test
fnSourceEnvironments

[string]$CONNAME=${env:CONNAME}
[string]$CHANNEL=${env:CHANNEL}
[string]$CERTLABL=${env:CERTLABL}
[string]$SSLCIPH=${env:SSLCIPH}
#[string]$MQSSLKEYR=${env:MQSSLKEYR}

#---------------------------------------------
# Functions for Command Execution
#---------------------------------------------
function fnExecCmd
{
    $EXECCMD=$args[0]
    Write-Host ""
    Write-Host "Command: $EXECCMD"
    Write-Host ""

    Invoke-Expression "$EXECCMD" | Write-Host

    return $RET_OK
}

#------------------------------------------------------------------
# Functions for checking all channel
#
# input:
# $TARGET_QMGR:  Queue Manager Name
# ${TARGET_QMGR}.mqsc.src:  MQSC source file
#------------------------------------------------------------------
function fnCheckChannelStatus
{
    $CPH = ""
    if ($SSLCIPH -ne "" )
    {
        #Write-Host "SSLCIPH: $SSLCIPH"
        $CPH = "-cs $SSLCIPH"
    }

    $CLB = ""
    if ( $CERTLABL -ne "" )
    {
        #Write-Host "CERTLABL: $CERTLABL"
        $CLB = "-lb $CERTLABL MQCD_VERSION_11"
    }

    $sourcefile = "${TARGET_QMGR}.mqsc"

    if (!(Test-Path ./$sourceFile))
    {
        Write-Host "Cannot find source file ./$sourcefile"
        return $RET_NG
    }

    $f = (Get-Content ./$sourcefile | select-string "^\s*$" -notmatch | select-string "^\s*#.*$" -notmatch `
        | select-string "^[^`*]*def.*chl" ) -as [string[]]
    $i = 1
    foreach ($line in $f)
    {
        $chlnames = $line.Split("()")
        $cmdstring = "mqpcfc chs -qm ${TARGET_QMGR} -c " + $chlnames[1] + " -x `"$CONNAME`" -ch $CHANNEL $CPH $CLB STATUS SECPROT SSLCERTI SSLCIPH SSLPEER"
        fnExecCmd $cmdstring
        $i++
    }

    return $RET_OK
}

#----------------
# Program start
#----------------
if ($m -eq "")
{
    $script_name = $myInvocation.MyCommand.name
    Write-output "${script_name} -m <Qmgr>"
    exit(1)
}

$TARGET_QMGR = $m

# Check Channel Status
$retcd = fnCheckChannelStatus
exit $retcd

