import java.util.*;
import java.io.*;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import com.ibm.wmqfte.exitroutine.api.*;

public class SampleStartExit implements SourceTransferStartExit{
    public TransferExitResult onSourceTransferStart(String sourceAgentName,
                                                    String destinationAgentName,
                                                    Map<String, String> environmentMetaData,
                                                    Map<String, String>transferMetaData,
                                                    List<SourceFileExitFileSpecification>fileSpecs){
        try{
            System.out.println("SourceTransferStartExit Start!");

            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            String vmName = bean.getName();
            long pid = Long.valueOf(vmName.split("@")[0]);
            System.out.println("VM Name : " + vmName);
            System.out.println("PID : " + pid);

            System.out.println(Thread.currentThread().getName());

            FileWriter fileWriter = new FileWriter("/tmp/Metadata.txt");
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("SourceTransferStartExit Start");
            printWriter.println("SourceAgentName : " + sourceAgentName);
            printWriter.println("DestinationAgentName : " + destinationAgentName);
            printWriter.println("EnvironmentMetaData : ");
            for( String key : environmentMetaData.keySet()){
                printWriter.println(" key: " + key + ", value: " +
                    environmentMetaData.get(key));
            }
            printWriter.println("TransferMetaData : ");
            for( String key : transferMetaData.keySet()){
                printWriter.println(" key: " + key + ", value: " +
                    transferMetaData.get(key));
            }
            printWriter.println("FileMetaData : ");
            Iterator i = fileSpecs.iterator();
            while(i.hasNext()){
                SourceFileExitFileSpecification sp =
                    (SourceFileExitFileSpecification) i.next();
                printWriter.println(sp.getSource());
                printWriter.println(sp.getDestination());
                for( String key : sp.getSourceFileMetaData().keySet()){
                    printWriter.println(" key: " + key + ", value: " +
                        sp.getSourceFileMetaData().get(key));
                }
            }
            System.out.println("SourceTransferStartExit Stop!");
            printWriter.close();
            fileWriter.close();
        }catch(IOException ioe){
        }catch(Exception e){
        }
        return TransferExitResult.PROCEED_RESULT;
    }
}
