import java.util.List;
import java.util.Map;
import java.util.Iterator;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

import com.ibm.wmqfte.exitroutine.api.DestinationTransferEndExit;
import com.ibm.wmqfte.exitroutine.api.TransferExitResult;
import com.ibm.wmqfte.exitroutine.api.FileTransferResult;


public class SampleDstEndExit implements DestinationTransferEndExit {

	public String onDestinationTransferEnd(TransferExitResult transferExitResult,
					String sourceAgentName,
					String destinationAgentName,
					Map<String, String>environmentMetaData,
					Map<String, String>transferMetaData, 
					List<FileTransferResult>fileResults) {

		System.out.println("DestinationTransferEndExit Start!");

                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                String vmName = bean.getName();
                long pid = Long.valueOf(vmName.split("@")[0]);
                System.out.println("VM Name : " + vmName);
                System.out.println("PID : " + pid);

                System.out.println(Thread.currentThread().getName());

                System.out.println("Environment Meta Data: " + environmentMetaData);
                System.out.println("Transfer Meta Data:    " + transferMetaData);

                System.out.println("Source agent:          " +
                                sourceAgentName);
                System.out.println("Destination agent:     " +
                                destinationAgentName);

                if (fileResults.isEmpty()) {
                        System.out.println("No files in the list");
                        return "No files";
                }
                else {

                        System.out.println( "File list: ");

                        final Iterator<FileTransferResult> iterator = fileResults.iterator();

                        while (iterator.hasNext()){
                                final FileTransferResult thisFileSpec = iterator.next();
                                System.out.println("Source file spec: "  +
                                                thisFileSpec.getSourceFileSpecification() +
                                                ", Destination file spec: " +
                                                thisFileSpec.getDestinationFileSpecification());
                        }
                }
		System.out.println("DestinationTransferEndExit Stop!");
		return "Done";
	}
}

